/*
 * Decompiled with CFR 0.152.
 */
package br.com.biscoitoback.backbiscoito.controller;

import br.com.biscoitoback.backbiscoito.model.Mensagem;
import br.com.biscoitoback.backbiscoito.service.MensagemService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mensagens"})
public class MensagemController {
    @Autowired
    private MensagemService mensagemService;

    @GetMapping
    public ResponseEntity<List<Mensagem>> listarMensagens() {
        List mensagens = this.mensagemService.listarMensagens();
        return new ResponseEntity((Object)mensagens, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Mensagem> buscarMensagemPorId(@PathVariable Long id) {
        Optional mensagem = this.mensagemService.buscarMensagemPorId(id);
        return mensagem.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<Mensagem> criarMensagem(@RequestBody Mensagem mensagem) {
        Mensagem mensagemSalva = this.mensagemService.salvarMensagem(mensagem);
        return new ResponseEntity((Object)mensagemSalva, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Mensagem> atualizarMensagem(@PathVariable Long id, @RequestBody Mensagem mensagemAtualizada) {
        Optional mensagem = this.mensagemService.buscarMensagemPorId(id);
        if (mensagem.isPresent()) {
            mensagemAtualizada.setId(id);
            Mensagem mensagemSalva = this.mensagemService.salvarMensagem(mensagemAtualizada);
            return ResponseEntity.ok((Object)mensagemSalva);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletarMensagem(@PathVariable Long id) {
        if (this.mensagemService.existeMensagem(id)) {
            this.mensagemService.deletarMensagem(id);
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

