/*
 * Decompiled with CFR 0.152.
 */
package br.com.biscoitoback.backbiscoito.controller;

import br.com.biscoitoback.backbiscoito.model.QrCodeResponse;
import br.com.biscoitoback.backbiscoito.model.Usuario;
import br.com.biscoitoback.backbiscoito.service.AsaasIntegrationService;
import br.com.biscoitoback.backbiscoito.service.UsuarioService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/usuarios"})
public class UsuarioController {
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private AsaasIntegrationService asaasIntegrationService;

    @GetMapping
    public ResponseEntity<List<Usuario>> listarUsuarios() {
        List usuarios = this.usuarioService.listarUsuarios();
        return new ResponseEntity((Object)usuarios, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Usuario> buscarUsuarioPorId(@PathVariable Long id) {
        Optional usuario = this.usuarioService.buscarUsuarioPorId(id);
        return usuario.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<Usuario> cadastrarUsuario(@RequestBody Usuario usuario) {
        Usuario usuarioSalvo = this.usuarioService.salvarUsuario(usuario);
        return new ResponseEntity((Object)usuarioSalvo, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Usuario> atualizarUsuario(@PathVariable Long id, @RequestBody Usuario usuarioAtualizado) {
        Optional usuario = this.usuarioService.buscarUsuarioPorId(id);
        if (usuario.isPresent()) {
            Usuario usuarioExistente = (Usuario)usuario.get();
            usuarioExistente.setNome(usuarioAtualizado.getNome());
            usuarioExistente.setEmail(usuarioAtualizado.getEmail());
            usuarioExistente.setMensagem(usuarioAtualizado.getMensagem());
            Usuario usuarioSalvo = this.usuarioService.salvarUsuario(usuarioExistente);
            return ResponseEntity.ok((Object)usuarioSalvo);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletarUsuario(@PathVariable Long id) {
        if (this.usuarioService.existeUsuario(id)) {
            this.usuarioService.deletarUsuario(id);
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/{id}/gerar-cobranca"})
    public ResponseEntity<Object> gerarCobranca(@PathVariable Long id) {
        Optional usuarioOptional = this.usuarioService.buscarUsuarioPorId(id);
        if (usuarioOptional.isPresent()) {
            Usuario usuario = (Usuario)usuarioOptional.get();
            try {
                String cobrancaId = this.asaasIntegrationService.gerarCobranca(usuario);
                return ResponseEntity.ok().body((Object)("{\"message\": \"Cobran\u00e7a gerada com sucesso. ID: " + cobrancaId + "\"}"));
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Erro ao gerar cobran\u00e7a: " + e.getMessage() + "\"}"));
            }
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/obter-qrcode-pix"})
    public ResponseEntity<Object> obterQrCodePix(@PathVariable Long id) {
        Optional usuarioOptional = this.usuarioService.buscarUsuarioPorId(id);
        if (usuarioOptional.isPresent()) {
            Usuario usuario = (Usuario)usuarioOptional.get();
            try {
                QrCodeResponse qrCodeResponse = this.asaasIntegrationService.obterQrCodePix(usuario);
                return ResponseEntity.ok().body((Object)qrCodeResponse);
            }
            catch (Exception e) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Erro ao obter QR Code do PIX: " + e.getMessage() + "\"}"));
            }
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping(value={"/reset-senha"})
    public ResponseEntity<Object> resetSenha(@RequestParam String email) {
        try {
            this.usuarioService.solicitarResetSenha(email);
            return ResponseEntity.ok().body((Object)"{\"message\": \"Instru\u00e7\u00f5es para reset de senha enviadas com sucesso.\"}");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)("{\"error\": \"Erro ao solicitar reset de senha: " + e.getMessage() + "\"}"));
        }
    }

    @PostMapping(value={"/alterar-senha"})
    public ResponseEntity<Object> alterarSenha(@RequestParam String email, @RequestParam int resetCode, @RequestParam String novaSenha) {
        try {
            boolean sucesso = this.usuarioService.alterarSenha(email, resetCode, novaSenha);
            if (sucesso) {
                return ResponseEntity.ok().body((Object)"{\"message\": \"Senha alterada com sucesso.\"}");
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"{\"error\": \"C\u00f3digo de redefini\u00e7\u00e3o inv\u00e1lido ou e-mail n\u00e3o encontrado.\"}");
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("{\"error\": \"Erro ao alterar a senha: " + e.getMessage() + "\"}"));
        }
    }
}

