/*
 * Decompiled with CFR 0.152.
 */
package br.com.biscoitoback.backbiscoito.service;

import br.com.biscoitoback.backbiscoito.model.QrCodeResponse;
import br.com.biscoitoback.backbiscoito.model.Usuario;
import br.com.biscoitoback.backbiscoito.repository.UsuarioRepository;
import br.com.biscoitoback.backbiscoito.service.InvalidCpfCnpjException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AsaasIntegrationService {
    private static final String ASaaS_API_URL = "https://sandbox.asaas.com/api/v3";
    private static final String ASaaS_API_TOKEN = "$aact_YTU5YTE0M2M2N2I4MTliNzk0YTI5N2U5MzdjNWZmNDQ6OjAwMDAwMDAwMDAwMDAwNjcxOTE6OiRhYWNoX2IzOGUwMDQxLTNlYzAtNDEwZS05MjcyLThjNzk1ZmUzY2FkZg==";
    private final HttpClient httpClient = HttpClient.newHttpClient();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final UsuarioRepository usuarioRepository;

    @Autowired
    public AsaasIntegrationService(UsuarioRepository usuarioRepository) {
        this.usuarioRepository = usuarioRepository;
    }

    public String criarClienteAsaas(Usuario usuario) throws Exception {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://sandbox.asaas.com/api/v3/customers")).header("accept", "application/json").header("content-type", "application/json").header("access_token", ASaaS_API_TOKEN).POST(HttpRequest.BodyPublishers.ofString("{\"name\":\"" + usuario.getNome() + "\",\"cpfCnpj\":\"" + usuario.getCpf() + "\",\"notificationDisabled\": true}")).build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            JsonNode rootNode = this.objectMapper.readTree(response.body());
            return rootNode.get("id").asText();
        }
        if (response.statusCode() == 400) {
            JsonNode rootNode = this.objectMapper.readTree(response.body());
            if (rootNode.has("errors")) {
                for (JsonNode error : rootNode.get("errors")) {
                    if (!"invalid_cpfCnpj".equals(error.get("code").asText())) continue;
                    throw new InvalidCpfCnpjException(error.get("description").asText());
                }
            }
            throw new Exception("Erro ao criar cliente na Asaas: " + response.statusCode() + ", " + response.body());
        }
        throw new Exception("Erro ao criar cliente na Asaas: " + response.statusCode() + ", " + response.body());
    }

    public String gerarCobranca(Usuario usuario) throws Exception {
        LocalDate vencimento = LocalDate.now().plusDays(2L);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String formattedDueDate = vencimento.format(formatter);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://sandbox.asaas.com/api/v3/payments")).header("accept", "application/json").header("content-type", "application/json").header("access_token", ASaaS_API_TOKEN).POST(HttpRequest.BodyPublishers.ofString("{\"billingType\":\"PIX\",\"customer\":\"" + usuario.getIdAsaas() + "\",\"value\":10,\"dueDate\":\"" + formattedDueDate + "\"}")).build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            JsonNode rootNode = this.objectMapper.readTree(response.body());
            String paymentId = rootNode.get("id").asText();
            usuario.setStatusPagamento("PENDENTE");
            usuario.setCodPagamento(paymentId);
            this.usuarioRepository.save((Object)usuario);
            return paymentId;
        }
        throw new Exception("Erro ao gerar cobran\u00e7a na Asaas: " + response.statusCode() + ", " + response.body());
    }

    public QrCodeResponse obterQrCodePix(Usuario usuario) throws Exception {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://sandbox.asaas.com/api/v3/payments/" + usuario.getCodPagamento() + "/pixQrCode")).header("accept", "application/json").header("access_token", ASaaS_API_TOKEN).GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() == 200) {
            JsonNode rootNode = this.objectMapper.readTree(response.body());
            String encodedImage = rootNode.get("encodedImage").asText();
            String payload = rootNode.get("payload").asText();
            QrCodeResponse qrCodeResponse = new QrCodeResponse();
            qrCodeResponse.setEncodedImage(encodedImage);
            qrCodeResponse.setPayload(payload);
            return qrCodeResponse;
        }
        throw new Exception("Erro ao obter QR Code do PIX: " + response.statusCode() + ", " + response.body());
    }
}

